/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.world;

import artifacts.common.config.ModConfig;
import artifacts.common.entity.MimicEntity;
import artifacts.common.init.ModEntityTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BlastFurnaceBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.FurnaceBlock;
import net.minecraft.world.level.block.SmokerBlock;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraftforge.common.Tags;

public class CampsiteFeature
extends Feature<NoneFeatureConfiguration> {
    private static final BlockStateProvider CAMPFIRES = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)Blocks.f_50683_.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true))), 4).m_146271_((Object)((BlockState)Blocks.f_50683_.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(false))), 20).m_146271_((Object)((BlockState)Blocks.f_50684_.m_49966_().m_61124_((Property)CampfireBlock.f_51227_, (Comparable)Boolean.valueOf(true))), 1));
    private static final BlockStateProvider DECORATIONS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50247_.m_49966_(), 2).m_146271_((Object)Blocks.f_50572_.m_49966_(), 2).m_146271_((Object)Blocks.f_50237_.m_49966_(), 2).m_146271_((Object)Blocks.f_50255_.m_49966_(), 1).m_146271_((Object)((BlockState)Blocks.f_152525_.m_49966_().m_61124_((Property)CandleCakeBlock.f_152850_, (Comparable)Boolean.valueOf(true))), 1));
    private static final BlockStateProvider CRAFTING_STATIONS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50091_.m_49966_(), 5).m_146271_((Object)Blocks.f_50625_.m_49966_(), 5).m_146271_((Object)Blocks.f_50622_.m_49966_(), 5).m_146271_((Object)Blocks.f_50621_.m_49966_(), 5).m_146271_((Object)Blocks.f_50322_.m_49966_(), 2).m_146271_((Object)Blocks.f_50323_.m_49966_(), 2).m_146271_((Object)Blocks.f_50324_.m_49966_(), 1));
    private static final BlockStateProvider FURNACES = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)((BlockState)Blocks.f_50094_.m_49966_().m_61124_((Property)FurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(false))), 2).m_146271_((Object)((BlockState)Blocks.f_50620_.m_49966_().m_61124_((Property)BlastFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(false))), 1).m_146271_((Object)((BlockState)Blocks.f_50619_.m_49966_().m_61124_((Property)SmokerBlock.f_48684_, (Comparable)Boolean.valueOf(false))), 1));
    private static final BlockStateProvider FURNACE_CHIMNEYS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50274_.m_49966_(), 2).m_146271_((Object)Blocks.f_152554_.m_49966_(), 2).m_146271_((Object)Blocks.f_50609_.m_49966_(), 1).m_146271_((Object)Blocks.f_152592_.m_49966_(), 1));
    private static final BlockStateProvider BEDS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50028_.m_49966_(), 1).m_146271_((Object)Blocks.f_50018_.m_49966_(), 1).m_146271_((Object)Blocks.f_50023_.m_49966_(), 1).m_146271_((Object)Blocks.f_50021_.m_49966_(), 1).m_146271_((Object)Blocks.f_50068_.m_49966_(), 1).m_146271_((Object)Blocks.f_50027_.m_49966_(), 1));
    private static final BlockStateProvider LIGHTS = new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)Blocks.f_50681_.m_49966_(), 3).m_146271_((Object)((BlockState)Blocks.f_152482_.m_49966_().m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true))), 1).m_146271_((Object)((BlockState)Blocks.f_152482_.m_49966_().m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(false))), 1).m_146271_((Object)Blocks.f_50682_.m_49966_(), 1));
    public static final ResourceLocation CHEST_LOOT = new ResourceLocation("artifacts", "chests/campsite_chest");
    public static final ResourceLocation BARREL_LOOT = new ResourceLocation("artifacts", "chests/campsite_barrel");

    public CampsiteFeature() {
        super(NoneFeatureConfiguration.f_67815_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        BlockPos origin = context.m_159777_();
        Random random = context.m_159776_();
        if (!this.isSufficientlyFlat(level, origin)) {
            return false;
        }
        BlockPos.m_121990_((BlockPos)origin.m_142082_(-2, 0, -2), (BlockPos)origin.m_142082_(2, 2, 2)).filter(pos -> Math.abs(pos.m_123341_() - origin.m_123341_()) < 2 || Math.abs(pos.m_123343_() - origin.m_123343_()) < 2).filter(pos -> !level.m_8055_(pos).m_60795_()).forEach(pos -> this.m_5974_((LevelWriter)level, (BlockPos)pos, Blocks.f_50627_.m_49966_()));
        this.placeFloor(level, origin, random);
        this.m_5974_((LevelWriter)level, origin, CAMPFIRES.m_7112_(random, origin));
        Direction direction = Direction.Plane.HORIZONTAL.m_122560_(random);
        BlockPos pos2 = origin.m_5484_(direction, 2);
        if (random.nextInt(3) == 0) {
            BlockPos.m_121990_((BlockPos)pos2.m_142300_(direction.m_122427_()), (BlockPos)pos2.m_142300_(direction.m_122428_())).forEach(barrelPos -> {
                this.placeBarrel(level, (BlockPos)barrelPos, random);
                if (random.nextInt(3) == 0) {
                    this.placeBarrel(level, barrelPos.m_7494_(), random);
                }
            });
        } else {
            Direction bedDirection = random.nextBoolean() ? direction.m_122427_() : direction.m_122428_();
            BlockState bedBlock = (BlockState)BEDS.m_7112_(random, pos2).m_61124_((Property)BedBlock.f_54117_, (Comparable)bedDirection);
            this.m_5974_((LevelWriter)level, pos2, (BlockState)bedBlock.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD));
            this.m_5974_((LevelWriter)level, pos2.m_142300_(bedDirection.m_122424_()), (BlockState)bedBlock.m_61124_((Property)BedBlock.f_49440_, (Comparable)BedPart.FOOT));
            this.placeBarrel(level, pos2.m_142300_(bedDirection), random);
            if (random.nextBoolean()) {
                this.m_5974_((LevelWriter)level, pos2.m_142300_(bedDirection).m_7494_(), LIGHTS.m_7112_(random, pos2));
            }
        }
        direction = random.nextBoolean() ? direction.m_122427_() : direction.m_122428_();
        pos2 = origin.m_5484_(direction, 2);
        List positions = BlockPos.m_121990_((BlockPos)pos2.m_142300_(direction.m_122427_()), (BlockPos)pos2.m_142300_(direction.m_122428_())).map(BlockPos::m_7949_).collect(Collectors.toCollection(ArrayList::new));
        Collections.shuffle(positions);
        this.placeCraftingStation(level, (BlockPos)positions.remove(0), random, direction.m_122424_());
        this.placeFurnace(level, (BlockPos)positions.remove(0), random, direction.m_122424_());
        this.placeChest(level, (BlockPos)positions.remove(0), random, direction.m_122424_());
        return true;
    }

    private boolean isSufficientlyFlat(WorldGenLevel level, BlockPos origin) {
        return BlockPos.m_121990_((BlockPos)origin.m_142082_(-2, 0, -2), (BlockPos)origin.m_142082_(2, 0, 2)).filter(pos -> level.m_8055_(pos.m_7495_()).m_60783_((BlockGetter)level, pos.m_7495_(), Direction.UP)).filter(pos -> level.m_8055_(pos).m_60795_()).count() >= 6L;
    }

    private void placeFloor(WorldGenLevel level, BlockPos origin, Random random) {
        BlockPos.m_121990_((BlockPos)origin.m_142082_(-2, -1, -2), (BlockPos)origin.m_142082_(2, -1, 2)).filter(pos -> Math.abs(pos.m_123341_() - origin.m_123341_()) < 2 || Math.abs(pos.m_123343_() - origin.m_123343_()) < 2).forEach(pos -> {
            if (!level.m_8055_(pos).m_60783_((BlockGetter)level, pos, Direction.UP)) {
                this.m_5974_((LevelWriter)level, (BlockPos)pos, Blocks.f_50705_.m_49966_());
            } else if (random.nextBoolean()) {
                if (level.m_8055_(pos).m_60713_(Blocks.f_152550_)) {
                    this.m_5974_((LevelWriter)level, (BlockPos)pos, Blocks.f_152551_.m_49966_());
                } else if (level.m_8055_(pos).m_60713_(Blocks.f_50069_)) {
                    this.m_5974_((LevelWriter)level, (BlockPos)pos, Blocks.f_50652_.m_49966_());
                }
            }
        });
    }

    private void placeCraftingStation(WorldGenLevel level, BlockPos pos, Random random, Direction facing) {
        BlockState craftingStation = CRAFTING_STATIONS.m_7112_(random, pos);
        if (craftingStation.m_61138_((Property)BlockStateProperties.f_61374_)) {
            craftingStation = (BlockState)craftingStation.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
        }
        this.m_5974_((LevelWriter)level, pos, craftingStation);
        if (random.nextInt(3) == 0) {
            this.m_5974_((LevelWriter)level, pos.m_7494_(), DECORATIONS.m_7112_(random, pos));
        }
    }

    private void placeFurnace(WorldGenLevel level, BlockPos pos, Random random, Direction facing) {
        BlockState furnace = FURNACES.m_7112_(random, pos);
        furnace = (BlockState)furnace.m_61124_((Property)FurnaceBlock.f_48683_, (Comparable)facing);
        this.m_5974_((LevelWriter)level, pos, furnace);
        if (random.nextBoolean()) {
            this.m_5974_((LevelWriter)level, pos.m_7494_(), FURNACE_CHIMNEYS.m_7112_(random, pos));
        }
    }

    private void placeBarrel(WorldGenLevel level, BlockPos pos, Random random) {
        BlockState barrel = Blocks.f_50618_.m_49966_();
        barrel = random.nextBoolean() ? (BlockState)barrel.m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.UP) : (BlockState)barrel.m_61124_((Property)BarrelBlock.f_49042_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random));
        this.m_5974_((LevelWriter)level, pos, barrel);
        RandomizableContainerBlockEntity.m_59620_((BlockGetter)level, (Random)random, (BlockPos)pos, (ResourceLocation)BARREL_LOOT);
    }

    public void placeChest(WorldGenLevel level, BlockPos pos, Random random, Direction facing) {
        if ((double)random.nextFloat() < (Double)ModConfig.common.campsiteMimicChance.get()) {
            MimicEntity mimic = (MimicEntity)((EntityType)ModEntityTypes.MIMIC.get()).m_20615_((Level)level.m_6018_());
            if (mimic != null) {
                mimic.setDormant(true);
                mimic.setFacing(facing);
                mimic.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
                level.m_7967_((Entity)mimic);
            }
        } else {
            BlockState chest;
            if (random.nextInt(8) == 0) {
                this.m_5974_((LevelWriter)level, pos.m_7495_(), Blocks.f_50077_.m_49966_());
                chest = Blocks.f_50325_.m_49966_();
                this.m_5974_((LevelWriter)level, pos, (BlockState)Blocks.f_50325_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.Plane.HORIZONTAL.m_122560_(random)));
            } else {
                chest = (Boolean)ModConfig.common.useModdedChests.get() != false ? Registry.f_122824_.m_203431_(Tags.Blocks.CHESTS_WOODEN).flatMap(set -> set.m_203450_(random)).map(Holder::m_203334_).orElse(Blocks.f_50087_).m_49966_() : Blocks.f_50087_.m_49966_();
            }
            if (chest.m_61138_((Property)BlockStateProperties.f_61374_)) {
                chest = (BlockState)chest.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
            }
            this.m_5974_((LevelWriter)level, pos, chest);
            RandomizableContainerBlockEntity.m_59620_((BlockGetter)level, (Random)random, (BlockPos)pos, (ResourceLocation)CHEST_LOOT);
        }
    }
}

